import numpy as np
## Tests transitivites
def test_transitivite_simple(graphe):
    '''graphe est une liste contenant les listes d'adjacence dont les 3 sommets ne
    sont pas tous reliés entre eux.
    Dans les sous-listes, un nombre positif représente un sommet successeur
    et un nombre négatif un sommet prédécesseur du sommet courant.
    Sortie : Booleen si le graphe orienté de 3 noeuds
    n'est pas transitif -> False'''
    n=len(graphe)
    assert n==3 # Vérification de la taille limite du graphe
    for i in range(n): # Pour tous les sommets du sous-graphe (ou graphe)
        if len(graphe[i])==2: # Lorsque l'on trouve le sommet central
            if graphe[i][0]*graphe[i][1]<0: # S'il y a un successeur et un predecesseur alors le graphe n'est pas transitif
                return False
            else:
                return True



def test_transitivite_boucle(graphe):
    '''graphe est une liste contenant les listes d'adjacence dont les 3 sommets ne
    sont pas tous reliés entre eux.
    Dans les sous-listes, un nombre positif représente un sommet successeur
    et un nombre négatif un sommet prédécesseur du sommet courant.
    Sortie : Booleen si le graphe orienté de 3 noeuds
    est transitif ou non'''
    n=len(graphe)
    assert n==3 # Vérification de la taille limite du graphe
    compteur=0 # Compteur pour savoir combien de sommet courant possède un successeur et un prédecesseur
    for i in range(n): # Pour tous les sommets du sous-graphe (ou graphe)
        if graphe[i][0]*graphe[i][1]<0: 
            compteur=compteur+1
    return compteur==1 # Si le compteur vaut 1 alors la transitivité est vérifiée.
    
def test_lien_sous_graphe(graphe):
    '''graphe est une liste contenant les listes d'adjacence
    Si les sommets sont tous reliés alors la fonction renverra True, False sinon
    '''
    compteur_taille_2=0   # Compteur du nombre de sous-listes de taille 2
    for i in range(len(graphe)): # Pour toutes les sous-listes de graphe
        if len(graphe[i])==2: # Si la sous-liste est de taille 2
            compteur_taille_2+=1
    return compteur_taille_2==3 # Si toutes les sous-listes sont de taille 2 alors tous les sommets sont reliés entre eux.
        
def creation_liste(voisins,matrice):
    L=[]
    temp=matrice[voisins[0]][voisins[2]] # On teste le lien entre le premier noeud i et dernier noeud k
    if temp==0:
        L1=[(voisins[1]+1)*matrice[voisins[0]][voisins[1]]]
        L2=[(voisins[0]+1)*matrice[voisins[1]][voisins[0]],(voisins[2]+1)*matrice[voisins[1]][voisins[2]]]
        L3=[(voisins[1]+1)*matrice[voisins[2]][voisins[1]]]
    else:
        L1=[(voisins[1]+1)*matrice[voisins[0]][voisins[1]],(voisins[2]+1)*temp]
        L2=[(voisins[0]+1)*matrice[voisins[1]][voisins[0]],(voisins[2]+1)*matrice[voisins[1]][voisins[2]]]
        L3=[(voisins[0]+1)*(-temp),(voisins[1]+1)*matrice[voisins[2]][voisins[1]]]
    L.append(L1)
    L.append(L2)
    L.append(L3)
    return L
    
        
matrice=np.array([[0,1,1,0,1,1],[-1,0,0,-1,0,1],[-1,0,0,0,-1,0],[0,1,0,0,0,1],[-1,0,1,0,0,1],[-1,-1,0,-1,-1,0]])

#matrice=np.array([[0,1,1],[-1,0,1],[-1,-1,0]])


def test_comparabilité(matrice):
    n=len(matrice)
    for i in range(n):
        voisins_i=[j for j in range(n) if matrice[i][j]!=0]
        for j in voisins_i:
            voisins_j=[k for k in range(n) if matrice[j][k]!=0 and k!=i]
            for k in voisins_j:
                liste_voisins=[i,j,k]
                graphe=creation_liste(liste_voisins,matrice)
                if test_lien_sous_graphe(graphe):
                    if test_transitivite_boucle(graphe)==False:
                        return False
                else:
                    if test_transitivite_simple(graphe)==False:
                        return False
    return True
                